/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "i2c.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "stdio.h"
#include "string.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

void I2C_Mem_Write(uint8_t slaveAddress, uint8_t regAddress, uint8_t *data, uint16_t length)
{
    // Generate START condition
    LL_I2C_GenerateStartCondition(I2C1);
    while(!LL_I2C_IsActiveFlag_SB(I2C1));

    // Send device address with write bit
    LL_I2C_TransmitData8(I2C1, (slaveAddress << 1) | 0x00);
    while(!LL_I2C_IsActiveFlag_ADDR(I2C1));
    LL_I2C_ClearFlag_ADDR(I2C1);

    // Send regAddress
    LL_I2C_TransmitData8(I2C1, regAddress);
    while(!LL_I2C_IsActiveFlag_TXE(I2C1));

    // Send all data bytes
    for(uint16_t i = 0; i < length; i++)
    {
        LL_I2C_TransmitData8(I2C1, data[i]);
        while(!LL_I2C_IsActiveFlag_TXE(I2C1));
    }

    // Generate STOP condition
    LL_I2C_GenerateStopCondition(I2C1);
}

void I2C_Mem_Read(uint8_t slaveAddress, uint16_t regAddress, uint8_t regLen, uint8_t *data, uint16_t length)
{
    // Write phase: Send register address
    LL_I2C_GenerateStartCondition(I2C1);
    while(!LL_I2C_IsActiveFlag_SB(I2C1));

    LL_I2C_TransmitData8(I2C1, (slaveAddress << 1) | 0x00);
    while(!LL_I2C_IsActiveFlag_ADDR(I2C1));
    LL_I2C_ClearFlag_ADDR(I2C1);

    if (regLen == 1)
    {
        LL_I2C_TransmitData8(I2C1, regAddress & 0xFF);
        while(!LL_I2C_IsActiveFlag_TXE(I2C1));
    }

    else if (regLen == 2)
    {
        // Send regAddress high byte
        LL_I2C_TransmitData8(I2C1, (uint8_t)(regAddress >> 8));
        while(!LL_I2C_IsActiveFlag_TXE(I2C1));

        // Send regAddress low byte
        LL_I2C_TransmitData8(I2C1, (uint8_t)(regAddress & 0xFF));
        while(!LL_I2C_IsActiveFlag_TXE(I2C1));
    }


    // Read phase: Get data bytes
    LL_I2C_GenerateStartCondition(I2C1);
    while(!LL_I2C_IsActiveFlag_SB(I2C1));

    LL_I2C_TransmitData8(I2C1, (slaveAddress << 1) | 0x01);
    while(!LL_I2C_IsActiveFlag_ADDR(I2C1));

    LL_I2C_AcknowledgeNextData(I2C1, LL_I2C_ACK);
    LL_I2C_ClearFlag_ADDR(I2C1);

    // Read all bytes
    for(uint16_t i = 0; i < length; i++)
    {
        if(i == length - 1)
        {
            LL_I2C_AcknowledgeNextData(I2C1, LL_I2C_NACK);  // If last byte, Send NACK
        }

        while(!LL_I2C_IsActiveFlag_RXNE(I2C1));
        data[i] = LL_I2C_ReceiveData8(I2C1);
    }

    LL_I2C_GenerateStopCondition(I2C1);
}


#define MPU6050_ADDRESS 0x68
#define WHO_AM_I_REG    0x75
#define ACCEL_XOUT_H_REG  0x3B
#define PWR_MGMT_1_REG    0x6B
#define TEMP_OUT_H_REG    0x41

uint8_t temp_data[2];
uint8_t accel_data[6];
int16_t accel_x, accel_y, accel_z;
int16_t temperature;

uint8_t device_id;


/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_SYSCFG);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);

  /* System interrupt init*/
  NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);

  /* SysTick_IRQn interrupt configuration */
  NVIC_SetPriority(SysTick_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(),15, 0));

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_I2C1_Init();
  MX_USART2_UART_Init();
  /* USER CODE BEGIN 2 */

  // Wake up MPU6050 (disable sleep mode)
  uint8_t wake_command = 0x00;
  I2C_Mem_Write(MPU6050_ADDRESS, PWR_MGMT_1_REG, &wake_command, 1);

  // Read WHO_AM_I register
  I2C_Mem_Read(MPU6050_ADDRESS, WHO_AM_I_REG, 1, &device_id, 1);

  if(device_id == 0x68)
  {
      // MPU6050 detected successfully
  }

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */

      // Read 6 bytes starting from register 0x3B
      I2C_Mem_Read(MPU6050_ADDRESS, ACCEL_XOUT_H_REG, 1, accel_data, 6);
      I2C_Mem_Read(MPU6050_ADDRESS, TEMP_OUT_H_REG, 1, temp_data, 2);

      // Combine bytes into 16-bit signed values
      accel_x = (int16_t)((accel_data[0] << 8) | accel_data[1]);
      accel_y = (int16_t)((accel_data[2] << 8) | accel_data[3]);
      accel_z = (int16_t)((accel_data[4] << 8) | accel_data[5]);

      temperature = (int16_t)((temp_data[0] << 8) | temp_data[1]);

      // Convert temperature
      float temp_c = (temperature / 340.0) + 36.53;

      // Send over UART
      char buffer[80];
      sprintf(buffer, "X:%d Y:%d Z:%d Temp:%.1fC\r\n", accel_x, accel_y, accel_z, temp_c);

      for(int i = 0; buffer[i] != '\0'; i++)
      {
          while(!LL_USART_IsActiveFlag_TXE(USART2));
          LL_USART_TransmitData8(USART2, buffer[i]);
      }

      LL_mDelay(100);

  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  LL_FLASH_SetLatency(LL_FLASH_LATENCY_5);
  while(LL_FLASH_GetLatency()!= LL_FLASH_LATENCY_5)
  {
  }
  LL_PWR_SetRegulVoltageScaling(LL_PWR_REGU_VOLTAGE_SCALE1);
  LL_PWR_EnableOverDriveMode();
  LL_RCC_HSE_EnableBypass();
  LL_RCC_HSE_Enable();

   /* Wait till HSE is ready */
  while(LL_RCC_HSE_IsReady() != 1)
  {

  }
  LL_RCC_PLL_ConfigDomain_SYS(LL_RCC_PLLSOURCE_HSE, LL_RCC_PLLM_DIV_4, 180, LL_RCC_PLLP_DIV_2);
  LL_RCC_PLL_Enable();

   /* Wait till PLL is ready */
  while(LL_RCC_PLL_IsReady() != 1)
  {

  }
  while (LL_PWR_IsActiveFlag_VOS() == 0)
  {
  }
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_1);
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_4);
  LL_RCC_SetAPB2Prescaler(LL_RCC_APB2_DIV_2);
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_PLL);

   /* Wait till System clock is ready */
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_PLL)
  {

  }
  LL_Init1msTick(180000000);
  LL_SetSystemCoreClock(180000000);
  LL_RCC_SetTIMPrescaler(LL_RCC_TIM_PRESCALER_TWICE);
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
