#include <stdint.h>
#include <stdbool.h>
#include "driverlib/systick.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"
#include <stdio.h>
#include "basic_conf.h"


// SysTick for delay
volatile uint32_t msTicks = 0;

void SysTick_Handler(void)
{
    msTicks++;
}

void delay_ms(uint32_t ms)
{
    uint32_t start = msTicks;
    while ((msTicks - start) < ms) {}
}

void SysTick_Init(void)
{
    SysTickPeriodSet(SysCtlClockGet() / 1000);
    SysTickIntRegister(SysTick_Handler);
    SysTickIntEnable();
    SysTickEnable();
}

// System clock configuration
void systemClockConfig(void)
{
    SysCtlClockSet(SYSCTL_XTAL_16MHZ | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_SYSDIV_2_5);  // 16MHz Osc -> 80MHz PLL Clock
    uint32_t waitTime = 1000000;
    while (waitTime--){}
    SysTick_Init();
}


void float_to_string(float num, char *buffer, int precision)
{
    // Handle negative numbers
    if (num < 0) {
        *buffer++ = '-';
        num = -num;
    }

    // Apply rounding:
    // Example: for precision=3 → add 0.0005 before truncation
    float rounding = 0.5f;
    int i = 0;
    for (i = 0; i < precision; i++)
        rounding /= 10.0f;

    num += rounding;

    // Extract integer part
    int int_part = (int)num;

    // Extract fractional part
    float frac = num - (float)int_part;

    // Convert integer part
    char temp[16];
    i = 0;
    if (int_part == 0) {
        temp[i++] = '0';
    } else {
        while (int_part > 0) {
            temp[i++] = (int_part % 10) + '0';
            int_part /= 10;
        }
    }

    // Reverse digits
    while (i--)
        *buffer++ = temp[i];

    // If no decimals requested
    if (precision == 0) {
        *buffer = '\0';
        return;
    }

    // Decimal point
    *buffer++ = '.';

    // Fractional digits
    int p=0;
    for (p = 0; p < precision; p++) {
        frac *= 10.0f;
        int digit = (int)frac;
        *buffer++ = digit + '0';
        frac -= digit;
    }

    // End string
    *buffer = '\0';
}

