#include <Arduino_FreeRTOS.h>
#include <semphr.h>

// Pin definitions
const int buttonPin = 2; // Button connected here
const int ledPin = 13;   // Built-in LED

// Binary semaphore handle
SemaphoreHandle_t buttonSemaphore;

// ----------------------------
// Interrupt Service Routine
// ----------------------------
void buttonISR() {
  BaseType_t xHigherPriorityTaskWoken = pdFALSE;

  // Give semaphore to unblock the task
  xSemaphoreGiveFromISR(buttonSemaphore, &xHigherPriorityTaskWoken);

  // Yield to task immediately if higher priority task woken
  portYIELD_FROM_ISR();
}

// ----------------------------
// Task to handle button press
// ----------------------------
void ButtonTask(void *pvParameters) {
  pinMode(ledPin, OUTPUT);

  while (1) {
    // Wait for button event
    if (xSemaphoreTake(buttonSemaphore, portMAX_DELAY) == pdTRUE) {

      // Simple software debounce
      vTaskDelay(pdMS_TO_TICKS(150));

      // Check button still pressed
      if (digitalRead(buttonPin) == LOW) {
        digitalWrite(ledPin, !digitalRead(ledPin));
        Serial.println("Button pressed → LED toggled");
      }
    }
  }
}

// ----------------------------
// Arduino setup
// ----------------------------
void setup() {
  Serial.begin(9600);

  // Create binary semaphore (initially empty)
  buttonSemaphore = xSemaphoreCreateBinary();
  if (buttonSemaphore == NULL) {
    Serial.println("Failed to create semaphore!");
    while (1);
  }

  // Configure button pin and attach ISR
  pinMode(buttonPin, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(buttonPin), buttonISR, FALLING);

  // Create the button handling task
  xTaskCreate(
    ButtonTask,    // Task function
    "Button Task", // Task name
    128,           // Stack size
    NULL,          // Task parameters
    1,             // Priority
    NULL           // Task handle
  );

  Serial.println("Setup complete. Press the button to toggle LED.");
}

// ----------------------------
// Arduino loop (not used)
// ----------------------------
void loop() {
  // Empty: all logic handled by FreeRTOS tasks
}