#include <Adafruit_NeoPixel.h>

#define LED_PIN 6
#define LED_COUNT 8

Adafruit_NeoPixel ring(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);

// Function to create rainbow colors
uint32_t Wheel(byte position) {
  position = 255 - position;
  if (position < 85) {
    return ring.Color(255 - position * 3, 0, position * 3);
  } else if (position < 170) {
    position -= 85;
    return ring.Color(0, position * 3, 255 - position * 3);
  } else {
    position -= 170;
    return ring.Color(position * 3, 255 - position * 3, 0);
  }
}

void setup() {
  ring.begin();
  ring.show();
}

void loop() {
  for (int j = 0; j < 256; j++) {
    for (int i = 0; i < LED_COUNT; i++) {
      ring.setPixelColor(i, Wheel((i + j) & 255));
    }
    ring.show();
    delay(20);
  }
}