#include <Wire.h>
#include <TM1637Display.h>
#include "RTClib.h"

#define CLK 3
#define DIO 2

TM1637Display display(CLK, DIO);
RTC_DS3231 rtc;

bool colonState = true;  // For blinking colon
unsigned long previousMillis = 0;

void setup() {
  Wire.begin();
  rtc.begin();
    // Set RTC using the compile time
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  display.setBrightness(7);
}

void loop() {
  unsigned long currentMillis = millis();

  // Display time normally for 5 seconds
  if (currentMillis - previousMillis < 5000) {
    DateTime now = rtc.now();

    int hour = now.hour();
    int minute = now.minute();
    int timeValue = hour * 100 + minute;

    // Blink colon every second
    display.showNumberDecEx(timeValue, colonState ? 0b11100000 : 0b00000000, true);
    colonState = !colonState;
    delay(1000);
  } 
  // Display temperature for 2 seconds
  else if (currentMillis - previousMillis < 7000) {
    float temp = rtc.getTemperature();
    int tempInt = (int)temp;

    // Custom segments for °C symbol on the last digit
    uint8_t segments[] = {
      display.encodeDigit(tempInt / 10),  // Tens
      display.encodeDigit(tempInt % 10),  // Units
      0,                                  // Blank
      0b01100011                           // °C symbol (custom segment)
    };
    display.setSegments(segments);
    delay(2000);
  } 
  else {
    // Reset timer
    previousMillis = currentMillis;
  }
}