#include <TM1637Display.h>

#define CLK 3
#define DIO 2

TM1637Display display(CLK, DIO);

int seconds = 0;
int minutes = 0;
bool colonState = true;  // To toggle the colon

void setup() {
  display.setBrightness(7);
}

void loop() {
  seconds++;
  if (seconds == 60) {
    seconds = 0;
    minutes++;
  }

  int timeValue = minutes * 100 + seconds;
  
  // Toggle colon every second
  display.showNumberDecEx(timeValue, colonState ? 0b11100000 : 0b00000000, true);
  colonState = !colonState;

  delay(1000);
}