#include <Wire.h>
#include <TM1637Display.h>
#include "RTClib.h"

#define CLK 3
#define DIO 2

TM1637Display display(CLK, DIO);
RTC_DS3231 rtc;

bool colonState = true;  // To toggle the colon

void setup() {
  Wire.begin();
  rtc.begin();
    // Set RTC using the compile time
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  display.setBrightness(7);
}

void loop() {
  DateTime now = rtc.now();

  int hour = now.hour();
  int minute = now.minute();

  int timeValue = hour * 100 + minute;

  // Toggle colon for blinking effect
  display.showNumberDecEx(timeValue, colonState ? 0b11100000 : 0b00000000, true);
  colonState = !colonState;

  delay(1000);
}