#include <Arduino_FreeRTOS.h>

void TaskBlink(void *pvParameters);
void TaskSerial(void *pvParameters);

void setup()
{
  xTaskCreate(TaskBlink, "LED Blink", 128, NULL, 1, NULL);
  xTaskCreate(TaskSerial, "Serial Print", 256, NULL, 1, NULL);
}

void loop()
{
  // Not used when FreeRTOS is running
}

void TaskBlink(void *pvParameters)
{
  pinMode(LED_BUILTIN, OUTPUT);

  while (1)
  {
    digitalWrite(LED_BUILTIN, HIGH);
    vTaskDelay(500 / portTICK_PERIOD_MS);

    digitalWrite(LED_BUILTIN, LOW);
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

void TaskSerial(void *pvParameters)
{
  Serial.begin(9600);
  vTaskDelay(100 / portTICK_PERIOD_MS);

  while (1)
  {
    Serial.println("FreeRTOS is running...");
    vTaskDelay(700 / portTICK_PERIOD_MS);
  }
}