#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <XPT2046_Touchscreen.h>

#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8

#define TOUCH_CS  6

Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);
XPT2046_Touchscreen touch(TOUCH_CS);

void setup() {
  Serial.begin(9600);

  tft.begin();
  tft.fillScreen(ILI9341_BLACK);
  tft.setRotation(2);

  touch.begin();
  touch.setRotation(0);   // Match display rotation

  tft.setTextSize(2);
  tft.setTextColor(ILI9341_GREEN);
  tft.setCursor(10, 10);
  tft.println("Touch Test");
}

void loop() {
  if (touch.touched()) {
    TS_Point p = touch.getPoint();  // Get raw touch point

    Serial.print("X = ");
    Serial.print(p.x);
    Serial.print("  Y = ");
    Serial.println(p.y);

    // Draw a dot where touched (not calibrated yet)
    int x = map(p.x, 200, 3800, 0, 240);
    int y = map(p.y, 200, 3800, 0, 320);

    tft.fillCircle(x, y, 3, ILI9341_YELLOW);
  }
  delay(5);
}