#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <XPT2046_Touchscreen.h>

#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8

#define TOUCH_CS  6

Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);
XPT2046_Touchscreen touch(TOUCH_CS);

int xMinVal, xMaxVal, yMinVal, yMaxVal;

TS_Point waitForTouch() {
  while (!touch.touched())
  {
    delay(5);
  }
  delay(200);
  TS_Point p = touch.getPoint();
  while (touch.touched());
  delay(200);
  return p;
}

void setup() {
  Serial.begin(9600);
  tft.begin();
  tft.setRotation(2);

  touch.begin();
  touch.setRotation(0);

  tft.fillScreen(ILI9341_BLACK);
  tft.setTextSize(2);
  tft.setTextColor(ILI9341_WHITE);

  // Ask user to touch four corners
  tft.fillScreen(ILI9341_BLACK);
  tft.setCursor(20, 140);
  tft.println("Touch TOP-LEFT");
  TS_Point p1 = waitForTouch();
  xMinVal = p1.x;
  yMinVal = p1.y;

  tft.fillScreen(ILI9341_BLACK);
  tft.setCursor(20, 140);
  tft.println("Touch TOP-RIGHT");
  TS_Point p2 = waitForTouch();
  xMaxVal = p2.x;

  tft.fillScreen(ILI9341_BLACK);
  tft.setCursor(20, 140);
  tft.println("Touch BOTTOM-LEFT");
  TS_Point p3 = waitForTouch();
  yMaxVal = p3.y;

  tft.fillScreen(ILI9341_BLACK);
  tft.setCursor(20, 140);
  tft.println("Calibration Done!");

  // Print values
  Serial.println("Calibration Values:");
  Serial.print("xMin = "); Serial.println(xMinVal);
  Serial.print("xMax = "); Serial.println(xMaxVal);
  Serial.print("yMin = "); Serial.println(yMinVal);
  Serial.print("yMax = "); Serial.println(yMaxVal);
}

void loop() {
}