#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>

#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8

Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);

const unsigned char smiley1 [] PROGMEM = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 
	0xff, 0xff, 0xe0, 0x0f, 0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 
	0xff, 0xff, 0x07, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc, 0x3f, 0xff, 
	0xff, 0xf8, 0x7f, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x87, 0xff, 
	0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 
	0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 
	0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3f, 
	0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 
	0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 
	0xf1, 0xff, 0xf0, 0xff, 0xff, 0x8f, 0xff, 0xc7, 0xe3, 0xff, 0xe0, 0x7f, 0xff, 0x07, 0xff, 0xc7, 
	0xe3, 0xff, 0xe0, 0x7f, 0xfe, 0x03, 0xff, 0xe3, 0xe7, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xe3, 
	0xc7, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xe3, 0xc7, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xf3, 
	0xc7, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xf1, 0xcf, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xf1, 
	0xcf, 0xff, 0xc0, 0x3f, 0xfe, 0x03, 0xff, 0xf1, 0xcf, 0xff, 0xe0, 0x7f, 0xfe, 0x03, 0xff, 0xf1, 
	0x8f, 0xff, 0xe0, 0x7f, 0xfe, 0x03, 0xff, 0xf9, 0x8f, 0xff, 0xf0, 0xff, 0xff, 0x07, 0xff, 0xf9, 
	0x8f, 0xff, 0xf9, 0xff, 0xff, 0x8f, 0xff, 0xf9, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 
	0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 
	0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 
	0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xc7, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0x3f, 0xf3, 
	0xc7, 0xfc, 0x7f, 0xff, 0xff, 0xfe, 0x3f, 0xe3, 0xe7, 0xfe, 0x3f, 0xff, 0xff, 0xfc, 0x3f, 0xe3, 
	0xe3, 0xfe, 0x1f, 0xff, 0xff, 0xf8, 0x7f, 0xe3, 0xe3, 0xff, 0x0f, 0xff, 0xff, 0xf0, 0xff, 0xc7, 
	0xf1, 0xff, 0x87, 0xff, 0xff, 0xe1, 0xff, 0xc7, 0xf1, 0xff, 0xc1, 0xff, 0xff, 0xc3, 0xff, 0x8f, 
	0xf8, 0xff, 0xe0, 0x7f, 0xff, 0x07, 0xff, 0x8f, 0xf8, 0xff, 0xf8, 0x0f, 0xf8, 0x0f, 0xff, 0x1f, 
	0xfc, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0x1f, 0xfc, 0x3f, 0xff, 0x80, 0x00, 0xff, 0xfe, 0x3f, 
	0xfe, 0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfc, 0x7f, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 
	0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 
	0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x87, 0xff, 
	0xff, 0xf8, 0x7f, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 
	0xff, 0xff, 0x07, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 
	0xff, 0xff, 0xe0, 0x0f, 0xf0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x1f, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

void setup() {
  tft.begin();
  tft.fillScreen(ILI9341_BLACK);
  tft.setRotation(1);

  // Draw title
  tft.setCursor(10, 10);
  tft.setTextSize(2);
  tft.setTextColor(ILI9341_YELLOW);
  tft.println("Bitmap Demo");

  // Draw bitmap on screen
  tft.drawBitmap(40, 40, smiley1, 64, 64, ILI9341_PINK);
}

void loop() {
}