#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <XPT2046_Touchscreen.h>

// --- Pins (use your original pins) ---
#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8
#define TOUCH_CS  6

// --- Objects (correct constructors) ---
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);
XPT2046_Touchscreen touch(TOUCH_CS);   // CS pin for XPT2046

#define MINPRESSURE 10
#define MAXPRESSURE 1000

// --- Replace these with the values you obtained from calibration ---
int xMinVal = 200;  // example: raw top-left X
int xMaxVal = 3900; // example: raw top-right X
int yMinVal = 200;  // example: raw top-left Y
int yMaxVal = 3900; // example: raw bottom-left Y

// Button coordinates (screen coordinates)
#define BTN1_X 40
#define BTN1_Y 80
#define BTN1_W 100
#define BTN1_H 50

#define BTN2_X 180
#define BTN2_Y 80
#define BTN2_W 100
#define BTN2_H 50

// Wait for a touch (debounced) and return raw point
TS_Point waitForTouch() {
  while (!touch.touched()) delay(5);    // wait for touch
  delay(100);                           // settle
  TS_Point p = touch.getPoint();
  while (touch.touched()) delay(5);     // wait for release
  delay(100);
  return p;
}

void drawButtons() {
  tft.fillRect(BTN1_X, BTN1_Y, BTN1_W, BTN1_H, ILI9341_RED);
  tft.setCursor(BTN1_X + 25, BTN1_Y + 18);
  tft.setTextColor(ILI9341_WHITE);
  tft.print("RED");

  tft.fillRect(BTN2_X, BTN2_Y, BTN2_W, BTN2_H, ILI9341_CYAN);
  tft.setCursor(BTN2_X + 25, BTN2_Y + 18);
  tft.setTextColor(ILI9341_BLACK);
  tft.print("CYAN");
}

bool checkButton(int tx, int ty, int bx, int by, int bw, int bh) {
  return (tx >= bx && tx <= (bx + bw) && ty >= by && ty <= (by + bh));
}

void setup() {
  Serial.begin(9600);

  // Initialize display and touch and set matching rotations
  tft.begin();
  tft.setRotation(1);      // change if you use a different rotation

  touch.begin();
  touch.setRotation(3);    // MUST match tft rotation for simple mapping

  tft.fillScreen(ILI9341_BLACK);
  tft.setTextSize(2);
  tft.setTextColor(ILI9341_WHITE);

  // Draw initial UI
  drawButtons();
}

void loop() {
  // read raw touch (non-blocking)
  if (!touch.touched()) {
    delay(10);
    return;
  }

  TS_Point p = touch.getPoint();

  // p.x and p.y are raw touch ADC values (range ~0..4095)
  // Map raw values from calibration to screen coordinates.
  // Replace xMinVal/xMaxVal/yMinVal/yMaxVal with your calibrated numbers.
  int sx = map(p.x, xMinVal, xMaxVal, 0, tft.width());
  int sy = map(p.y, yMinVal, yMaxVal, 0, tft.height());

  // Constrain to screen in case of small overshoot
  sx = constrain(sx, 0, tft.width());
  sy = constrain(sy, 0, tft.height());

  Serial.print("raw: "); Serial.print(p.x); Serial.print(","); Serial.print(p.y);
  Serial.print(" -> screen: "); Serial.print(sx); Serial.print(","); Serial.println(sy);

  // Check buttons and act
  if (checkButton(sx, sy, BTN1_X, BTN1_Y, BTN1_W, BTN1_H)) {
    tft.fillRect(BTN1_X, BTN1_Y, BTN1_W, BTN1_H, ILI9341_GREEN);
  } else if (checkButton(sx, sy, BTN2_X, BTN2_Y, BTN2_W, BTN2_H)) {
    tft.fillRect(BTN2_X, BTN2_Y, BTN2_W, BTN2_H, ILI9341_BLUE);
  }

  // small delay to avoid flooding
  delay(150);
}