#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <XPT2046_Touchscreen.h>

// ------------------- Pins -------------------
#define TFT_CS    10
#define TFT_DC     9
#define TFT_RST    8
#define TOUCH_CS   6

Adafruit_ILI9341 tft(TFT_CS, TFT_DC, TFT_RST);
XPT2046_Touchscreen ts(TOUCH_CS);

#define MINP 200   // minimal pressure

// ------------------- Buttons -------------------
#define BTN_W   160
#define BTN_H    50
#define BTN1_X   40
#define BTN1_Y   80
#define BTN2_X   40
#define BTN2_Y  150

// Draw the two buttons
void drawButtons() {
  tft.fillRoundRect(BTN1_X, BTN1_Y, BTN_W, BTN_H, 8, ILI9341_BLUE);
  tft.setCursor(BTN1_X + 20, BTN1_Y + 15);
  tft.setTextColor(ILI9341_WHITE);
  tft.setTextSize(2);
  tft.print("LED ON");

  tft.fillRoundRect(BTN2_X, BTN2_Y, BTN_W, BTN_H, 8, ILI9341_RED);
  tft.setCursor(BTN2_X + 20, BTN2_Y + 15);
  tft.setTextColor(ILI9341_WHITE);
  tft.setTextSize(2);
  tft.print("LED OFF");
}

void setup() {
  pinMode(5, OUTPUT);
  tft.begin();
  ts.begin();

  tft.setRotation(1);
  ts.setRotation(3);

  tft.fillScreen(ILI9341_BLACK);

  tft.setCursor(10, 10);
  tft.setTextColor(ILI9341_YELLOW);
  tft.setTextSize(2);
  tft.print("Control Panel");

  drawButtons();
}

void loop() {
  if (!ts.touched()){
    delay(10);
    return;
  } 

  TS_Point p = ts.getPoint();
  if (p.z < MINP) return;

  // Convert raw touch → screen coords
  int x = map(p.x, 200, 3800, 0, 320);
  int y = map(p.y, 200, 3800, 0, 240);

  // LED ON button
  if (x > BTN1_X && x < BTN1_X + BTN_W &&
      y > BTN1_Y && y < BTN1_Y + BTN_H) {

    digitalWrite(5, HIGH);

    tft.fillRect(0, 200, 320, 40, ILI9341_BLACK);
    tft.setCursor(10, 210);
    tft.setTextColor(ILI9341_GREEN);
    tft.setTextSize(2);
    tft.print("Status: LED Turned ON");
  }

  // LED OFF button
  if (x > BTN2_X && x < BTN2_X + BTN_W &&
      y > BTN2_Y && y < BTN2_Y + BTN_H) {

    digitalWrite(5, LOW);
    tft.fillRect(0, 200, 320, 40, ILI9341_BLACK);
    tft.setCursor(10, 210);
    tft.setTextColor(ILI9341_RED);
    tft.setTextSize(2);
    tft.print("Status: LED Turned OFF");
  }
}