#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>

// Pin definitions
#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8   // You can also connect this to 3.3V

// Create display object
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);

void setup() {
  tft.begin();                 // Start the display
  tft.setRotation (1);
  tft.fillScreen(ILI9341_BLACK); // Clear screen
  
  // Draw a welcome message
  tft.setCursor(20, 20);
  tft.setTextSize(2);
  tft.setTextColor(ILI9341_YELLOW);
  tft.println("ILI9341 Test");

  // Draw a red line
  tft.drawLine(10, 60, 230, 60, ILI9341_RED);

  // Draw a green rectangle
  tft.drawRect(10, 80, 100, 50, ILI9341_GREEN);

  // Filled blue rectangle
  tft.fillRect(120, 80, 100, 50, ILI9341_BLUE);

  // Draw a circle
  tft.drawCircle(60, 180, 30, ILI9341_CYAN);

  // Filled circle
  tft.fillCircle(180, 180, 30, ILI9341_MAGENTA);
}

void loop() {
  // Nothing here for now
}