#include <Arduino_FreeRTOS.h>
#include <timers.h> // Required for TimerHandle_t and software timers

/* Function Prototypes */
void ledTask(void *pvParameters);
void timingTask(void *pvParameters);
void heartbeatCallback(TimerHandle_t xTimer);

/* Software Timer Handle */
TimerHandle_t heartbeatTimer;

/* LED Pin Definitions */
const int LED1_PIN = 2; // LED controlled by periodic task
const int LED2_PIN = 3; // LED controlled by heartbeat timer

void setup() {
  Serial.begin(9600);

  // Initialize pins
  pinMode(LED1_PIN, OUTPUT);
  pinMode(LED2_PIN, OUTPUT);

  // -------------------------------
  // Create Periodic LED Task (LED1)
  // -------------------------------
  xTaskCreate(
    ledTask,
    "LED1 Task",
    128,
    NULL,
    1,
    NULL
  );

  // -------------------------------
  // Create Serial Timing Task
  // -------------------------------
  xTaskCreate(
    timingTask,
    "Timing Task",
    128,
    NULL,
    1,
    NULL
  );

  // -------------------------------
  // Create Auto-Reload Heartbeat Timer (LED2)
  // -------------------------------
  heartbeatTimer = xTimerCreate(
    "Heartbeat",
    pdMS_TO_TICKS(500),   // 500 ms period
    pdTRUE,               // Auto-reload
    NULL,
    heartbeatCallback
  );

  xTimerStart(heartbeatTimer, 0); // Start timer immediately
}

void loop() {
  // Empty. FreeRTOS scheduler handles everything
}

// -------------------------------------------------
// LED1 Task: toggles every 1 second
// -------------------------------------------------
void ledTask(void *pvParameters) {
  TickType_t lastWakeTime = xTaskGetTickCount();

  while (1) {
    digitalWrite(LED1_PIN, !digitalRead(LED1_PIN));
    vTaskDelayUntil(&lastWakeTime, pdMS_TO_TICKS(1000));
  }
}

// -------------------------------------------------
// Timing Task: prints timestamps every 1 second
// -------------------------------------------------
void timingTask(void *pvParameters) {
  TickType_t lastWakeTime = xTaskGetTickCount();

  while (1) {
    Serial.print("Timestamp (ms): ");
    Serial.println(millis());
    vTaskDelayUntil(&lastWakeTime, pdMS_TO_TICKS(1000));
  }
}

// -------------------------------------------------
// Heartbeat Timer Callback: toggles LED2 every 500 ms
// -------------------------------------------------
void heartbeatCallback(TimerHandle_t xTimer) {
  digitalWrite(LED2_PIN, !digitalRead(LED2_PIN));
}