#include <Arduino_FreeRTOS.h>

/* Task function prototypes */
void FastBlinkTask(void *pvParameters);
void SlowBlinkTask(void *pvParameters);
void SerialTask(void *pvParameters);

void setup()
{
  Serial.begin(9600);

  /* Create Fast Blink Task */
  if (xTaskCreate(FastBlinkTask, "FastBlink", 128, NULL, 1, NULL) != pdPASS)
  {
    Serial.println("FastBlink task creation failed");
  }

  /* Create Slow Blink Task */
  if (xTaskCreate(SlowBlinkTask, "SlowBlink", 128, NULL, 1, NULL) != pdPASS)
  {
    Serial.println("SlowBlink task creation failed");
  }

  /* Create Serial Logger Task */
  if (xTaskCreate(SerialTask, "Serial", 128, NULL, 1, NULL) != pdPASS)
  {
    Serial.println("Serial task creation failed");
  }

  /* Scheduler starts automatically */
}

void loop()
{
  /* Empty. FreeRTOS runs tasks */
}

/* ---------------- Task Definitions ---------------- */

void FastBlinkTask(void *pvParameters)
{
  pinMode(3, OUTPUT);

  while (1)
  {
    digitalWrite(3, HIGH);
    vTaskDelay(100 / portTICK_PERIOD_MS);

    digitalWrite(3, LOW);
    vTaskDelay(100 / portTICK_PERIOD_MS);
  }
}

void SlowBlinkTask(void *pvParameters)
{
  pinMode(2, OUTPUT);

  while (1)
  {
    digitalWrite(2, HIGH);
    vTaskDelay(1000 / portTICK_PERIOD_MS);

    digitalWrite(2, LOW);
    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}

void SerialTask(void *pvParameters)
{
  while (1)
  {
    Serial.println("Serial task running");
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}