#include <Arduino_FreeRTOS.h>
#include <semphr.h>

SemaphoreHandle_t BinSemaphore;

void HPT_Task(void *pvParameters);
void MPT_Task(void *pvParameters);
void LPT_Task(void *pvParameters);

void setup()
{
  Serial.begin(9600);
  while (!Serial);

  BinSemaphore = xSemaphoreCreateBinary();
  xSemaphoreGive(BinSemaphore);

  xTaskCreate(LPT_Task, "LPT", 128, NULL, 1, NULL);
  xTaskCreate(MPT_Task, "MPT", 128, NULL, 2, NULL);
  xTaskCreate(HPT_Task, "HPT", 128, NULL, 3, NULL);

  vTaskStartScheduler();
}

void loop() {}

void LPT_Task(void *pvParameters)
{
  while (1)
  {
    Serial.println("Entered LPT and About to take Semaphore\r\n");
    xSemaphoreTake(BinSemaphore, portMAX_DELAY);

    Serial.println("IN LPT...........................\r\n");
    vTaskDelay(3000 / portTICK_PERIOD_MS);   // holds resource

    Serial.println("Leaving LPT\r\n");
    xSemaphoreGive(BinSemaphore);

    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}

void MPT_Task(void *pvParameters)
{
  while (1)
  {
    Serial.println("In MPT*******************************\r\n");
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

void HPT_Task(void *pvParameters)
{
  while (1)
  {
    Serial.println("Entered HPT and About to take Semaphore\r\n");
    xSemaphoreTake(BinSemaphore, portMAX_DELAY);  // blocks here
    
    Serial.println("In HPT===========================\r\n");

    Serial.println("Leaving HPT\r\n");
    xSemaphoreGive(BinSemaphore);

    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}