#include <Arduino_FreeRTOS.h>
#include <semphr.h>

SemaphoreHandle_t sharedMutex;

// ---------------- LOW PRIORITY TASK ----------------
void LowPriorityTask(void *pvParameters)
{
  while (1)
  {
    if (xSemaphoreTake(sharedMutex, portMAX_DELAY))
    {
      Serial.print("LowPriorityTask: Holding resource | Priority: ");
      Serial.println(uxTaskPriorityGet(NULL));

      // Simulate long critical section
      vTaskDelay(2000 / portTICK_PERIOD_MS);

      Serial.print("LowPriorityTask: Releasing resource | Priority: ");
      Serial.println(uxTaskPriorityGet(NULL));

      xSemaphoreGive(sharedMutex);
    }

    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

// ---------------- MEDIUM PRIORITY TASK ----------------
void MediumPriorityTask(void *pvParameters)
{
  while (1)
  {
    Serial.println("MediumPriorityTask: Doing background work");
    vTaskDelay(500 / portTICK_PERIOD_MS);
  }
}

// ---------------- HIGH PRIORITY TASK ----------------
void HighPriorityTask(void *pvParameters)
{
  while (1)
  {
    // Let Low Priority Task grab mutex first
    vTaskDelay(1000 / portTICK_PERIOD_MS);

    Serial.println("HighPriorityTask: Needs shared resource");

    if (xSemaphoreTake(sharedMutex, portMAX_DELAY))
    {
      Serial.println("HighPriorityTask: Got shared resource");

      vTaskDelay(1000 / portTICK_PERIOD_MS);

      Serial.println("HighPriorityTask: Releasing shared resource");
      xSemaphoreGive(sharedMutex);
    }
  }
}

void setup()
{
  Serial.begin(9600);
  while (!Serial);

  sharedMutex = xSemaphoreCreateMutex();
  if (sharedMutex == NULL)
  {
    Serial.println("Failed to create mutex!");
    while (1);
  }

  // Priority: High > Medium > Low
  xTaskCreate(LowPriorityTask, "LowTask", 128, NULL, 1, NULL);
  xTaskCreate(MediumPriorityTask, "MediumTask", 128, NULL, 2, NULL);
  xTaskCreate(HighPriorityTask, "HighTask", 128, NULL, 3, NULL);
}

void loop() {}
