#include <Arduino_FreeRTOS.h>
#include <semphr.h>

TaskHandle_t HPThandler;
void HPT_TASK (void *pvParameters);

TaskHandle_t MPThandler;
void MPT_TASK (void *pvParameters);

TaskHandle_t LPThandler;
void LPT_TASK (void *pvParameters);

// semaphore related
SemaphoreHandle_t CountingSem;

// resource related
int resource[2] = {111,222};
int indx = 0;

void setup()
{
  Serial.begin(9600);
  while (!Serial);

  CountingSem = xSemaphoreCreateCounting(2,0);
  if (CountingSem == NULL)
    Serial.println("Unable to Create Semaphore\n\n");
  else
    Serial.println("Counting Semaphore created successfully\n\n");

  xTaskCreate(HPT_TASK, "HPT", 128, NULL, 3, &HPThandler);
  xTaskCreate(MPT_TASK, "MPT", 128, NULL, 2, &MPThandler);
  xTaskCreate(LPT_TASK, "LPT", 128, NULL, 1, &LPThandler);
}

void loop() {}

void HPT_TASK (void *pvParameters)
{
  // Give 2 semaphores at the beginning
  xSemaphoreGive(CountingSem);
  xSemaphoreGive(CountingSem);

  while (1)
  {
    Serial.println("Entered HPT Task\n About to ACQUIRE the Semaphore");
    Serial.print("Tokens available are: ");
    Serial.println(uxSemaphoreGetCount(CountingSem));

    xSemaphoreTake(CountingSem, portMAX_DELAY);

    Serial.print("Leaving HPT Task\n Data ACCESSED is:: ");
    Serial.println(resource[indx]);
    Serial.println("Not releasing the Semaphore\n\n");

    indx++;
    if (indx > 1) indx = 0;

    vTaskDelay(3000);
  }
}

void MPT_TASK (void *pvParameters)
{
  while (1)
  {
    Serial.println("Entered MPT Task\n About to ACQUIRE the Semaphore");
    Serial.print("Tokens available are: ");
    Serial.println(uxSemaphoreGetCount(CountingSem));

    xSemaphoreTake(CountingSem, portMAX_DELAY);

    Serial.print("Leaving MPT Task\n Data ACCESSED is:: ");
    Serial.println(resource[indx]);
    Serial.println("Not releasing the Semaphore\n\n");

    indx++;
    if (indx > 1) indx = 0;

    vTaskDelay(3000);
  }
}

void LPT_TASK (void *pvParameters)
{
  while (1)
  {
    Serial.println("Entered LPT Task\n About to ACQUIRE the Semaphore");
    Serial.print("Tokens available are: ");
    Serial.println(uxSemaphoreGetCount(CountingSem));

    xSemaphoreTake(CountingSem, portMAX_DELAY);

    Serial.print("Leaving LPT Task\n Data ACCESSED is:: ");
    Serial.println(resource[indx]);
    Serial.println("Not releasing the Semaphore\n\n");

    indx++;
    if (indx > 1) indx = 0;

    vTaskDelay(3000);
  }
}