#include <Arduino_FreeRTOS.h>
#include <semphr.h>

SemaphoreHandle_t ButtonSemaphore;

void ButtonTask(void *pvParameters);
void LEDTask(void *pvParameters);

void setup() {
  Serial.begin(9600);

  ButtonSemaphore = xSemaphoreCreateBinary();

  xTaskCreate(ButtonTask, "Button", 128, NULL, 2, NULL);
  xTaskCreate(LEDTask, "LED", 128, NULL, 1, NULL);

  vTaskStartScheduler();
}

void loop() {
  // Not used
}

void ButtonTask(void *pvParameters) {
  const int buttonPin = 2;
  pinMode(buttonPin, INPUT_PULLUP);

  while (1) {
    if (digitalRead(buttonPin) == LOW) {
      xSemaphoreGive(ButtonSemaphore);
      vTaskDelay(150 / portTICK_PERIOD_MS);  // debouncing
    }
    vTaskDelay(10 / portTICK_PERIOD_MS);
  }
}

void LEDTask(void *pvParameters) {
  const int ledPin = 13;
  pinMode(ledPin, OUTPUT);

  while (1) {
    if (xSemaphoreTake(ButtonSemaphore, portMAX_DELAY) == pdTRUE) {
      digitalWrite(ledPin, !digitalRead(ledPin));
    }
  }
}