#include <Arduino_FreeRTOS.h>
#include <queue.h>

QueueHandle_t adcQueue;

void TaskReadADC(void *pvParameters);
void TaskProcessADC(void *pvParameters);

void setup()
{
  Serial.begin(9600);

  pinMode(A0, INPUT);
  pinMode(9, OUTPUT);

  // Create a queue to hold 5 integer ADC values
  adcQueue = xQueueCreate(5, sizeof(int));

  if (adcQueue != NULL)
  {
    xTaskCreate(TaskReadADC, "ADC Read Task", 128, NULL, 1, NULL);
    xTaskCreate(TaskProcessADC, "ADC Process Task", 128, NULL, 1, NULL);
  }

  vTaskStartScheduler();
}

void loop()
{
  // Empty loop. FreeRTOS scheduler is running.
}

void TaskReadADC(void *pvParameters)
{
  int adcValue;

  while (1)
  {
    adcValue = analogRead(A0);

    // Send ADC value to the queue
    xQueueSend(adcQueue, &adcValue, portMAX_DELAY);

    vTaskDelay(pdMS_TO_TICKS(100));
  }
}

void TaskProcessADC(void *pvParameters)
{
  int receivedValue;

  while (1)
  {
    // Wait up to 200 ms for data from the queue
    if (xQueueReceive(adcQueue, &receivedValue, pdMS_TO_TICKS(200)))
    {
      int pwmValue = map(receivedValue, 0, 1023, 0, 255);
      analogWrite(9, pwmValue);

      Serial.println(receivedValue);
    }
  }
}