#include <Arduino_FreeRTOS.h>
#include <event_groups.h>

/* Pin definitions */
#define LED_PIN     13
#define BUTTON_PIN  2
#define POT_PIN     A0

/* Event bit definitions */
#define BIT_ADC_READY     (1 << 0)
#define BIT_BUTTON_PRESSED (1 << 1)

/* Event Group handle */
EventGroupHandle_t eventGroup;

/* Task prototypes */
void adcTask(void *pvParameters);
void buttonTask(void *pvParameters);
void ledTask(void *pvParameters);

int adcValue = 0;

void setup()
{
  Serial.begin(9600);
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUTTON_PIN, INPUT_PULLUP);

  /* Create Event Group */
  eventGroup = xEventGroupCreate();

  /* Create tasks */
  xTaskCreate(adcTask, "ADC Task", 128, NULL, 1, NULL);
  xTaskCreate(buttonTask, "Button Task", 128, NULL, 1, NULL);
  xTaskCreate(ledTask, "LED Task", 128, NULL, 1, NULL);
}

void loop()
{
  /* Empty. FreeRTOS runs tasks */
}

/* ADC Task */
void adcTask(void *pvParameters)
{
  while (1)
  {
    adcValue = analogRead(POT_PIN);

    /* Signal ADC ready */
    xEventGroupSetBits(eventGroup, BIT_ADC_READY);

    vTaskDelay(pdMS_TO_TICKS(500));
  }
}

/* Button Task */
void buttonTask(void *pvParameters)
{
  while (1)
  {
    if (digitalRead(BUTTON_PIN) == LOW)
    {
      /* Signal button pressed */
      xEventGroupSetBits(eventGroup, BIT_BUTTON_PRESSED);

      /* Simple debounce delay */
      vTaskDelay(pdMS_TO_TICKS(200));
    }
    vTaskDelay(pdMS_TO_TICKS(50));
  }
}

/* LED Control Task */
void ledTask(void *pvParameters)
{
  while (1)
  {
    xEventGroupWaitBits(
      eventGroup,
      BIT_ADC_READY | BIT_BUTTON_PRESSED,
      pdTRUE,   // Clear bits after exit
      pdTRUE,   // Wait for ALL bits
      portMAX_DELAY
    );

    digitalWrite(LED_PIN, HIGH);
    vTaskDelay(pdMS_TO_TICKS(500));
    Serial.println(adcValue);
    digitalWrite(LED_PIN, LOW);
  }
}