#include <OneWire.h>
#include <DallasTemperature.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define ONE_WIRE_BUS 2
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

void setup() {
  Serial.begin(9600);
  sensors.begin();

  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
}

void loop() {
  sensors.requestTemperatures();
  int deviceCount = sensors.getDeviceCount();

  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);

  for (int i = 0; i < deviceCount; i++) {
    float tempC = sensors.getTempCByIndex(i);

    // Print on serial
    Serial.print("Sensor ");
    Serial.print(i);
    Serial.print(": ");
    Serial.print(tempC);
    Serial.println(" °C");
    Serial.println();

    // Print on OLED
    display.print("S");
    display.print(i);
    display.print(": ");
    display.print(tempC);
    display.println(" C");
    display.println();
  }

  display.display();
  Serial.println("------------------");

  delay(1000);
}
