#include <SPIMemory.h>
SPIFlash flash;

void setup() {
  Serial.begin(9600);
  flash.begin();

  int address = 0;
  int dataToWrite = 5678;
  int dataRead = 0;

  // Step 1: Erase the sector before writing
  // This ensures the memory area is clean and ready for new data
  flash.eraseSector(address);

  // Step 2: Write integer data to flash
  if (flash.writeShort(address, dataToWrite) == true) {
    Serial.print("Integer Written to Flash: ");
    Serial.println(dataToWrite);
  } else Serial.println("Failed to Write Data");

  // Step 3: Read back the integer from flash
  dataRead = flash.readShort(address);
  Serial.print("Integer Read from Flash: ");
  Serial.println(dataRead);
}

void loop() {}
