#include <Wire.h>
#include <LiquidCrystal_I2C.h>

#define SHT31_ADDR 0x44    // Works for SHT30, SHT31, SHT35

LiquidCrystal_I2C lcd(0x27, 16, 2);  // Change 0x27 to 0x3F if needed

void setup() {
  Serial.begin(9600);
  Wire.begin();

  lcd.init();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("SHT3X Sensor");
}

void loop() {
  // Send measurement command
  Wire.beginTransmission(SHT31_ADDR);
  Wire.write(0x24);    // High repeatability
  Wire.write(0x00);
  Wire.endTransmission();

  delay(15);           // Wait for measurement

  // Read 6 bytes
  Wire.requestFrom(SHT31_ADDR, 6);
  if (Wire.available() == 6) {
    uint16_t rawT = (Wire.read() << 8) | Wire.read();
    Wire.read();      // skip CRC
    uint16_t rawH = (Wire.read() << 8) | Wire.read();
    Wire.read();      // skip CRC

    float temp = -45 + (175 * (rawT / 65535.0));
    float hum  = 100 * (rawH / 65535.0);

    // Print on Serial Monitor
    Serial.print("Temp: ");
    Serial.print(temp);
    Serial.print(" C  |  Humidity: ");
    Serial.print(hum);
    Serial.println(" %");

    // Print on LCD
    lcd.setCursor(0, 0);
    lcd.print("Temp: ");
    lcd.print(temp, 1);
    lcd.print((char)223); // degree symbol
    lcd.print("C   ");

    lcd.setCursor(0, 1);
    lcd.print("Hum : ");
    lcd.print(hum, 1);
    lcd.print("%    ");
  } else {
    Serial.println("Sensor Error!");
    lcd.setCursor(0, 0);
    lcd.print("Sensor Error     ");
  }

  delay(1000);
}
