#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_AHTX0.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);
Adafruit_AHTX0 aht;

void setup() {
  Serial.begin(9600);
  if (!aht.begin()) {
    Serial.println("Could not find AHT20 sensor. Check wiring!");
    while (1);
  }

  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    Serial.println("SSD1306 initialization failed!");
    while (1);
  }

  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 0);
  display.println("AHT20 Sensor Ready");
  display.display();
  delay(1000);
}

void loop() {
  sensors_event_t humidity, temperature;
  aht.getEvent(&humidity, &temperature);

  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);

  display.setCursor(0, 10);
  display.print("Temp: ");
  display.print(temperature.temperature);
  display.println(" C");

  display.setCursor(0, 30);
  display.print("Humidity: ");
  display.print(humidity.relative_humidity);
  display.println(" %");

  display.display();
  delay(2000);
}
