//*****************************************************************************
//
// blinky.c - Simple example to blink the on-board LED.
//
// Copyright (c) 2012-2020 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.2.0.295 of the EK-TM4C123GXL Firmware Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"
#include "driverlib/i2c.h"
#include "driverlib/pin_map.h"
#include "driverlib/interrupt.h"
#include "basic_conf.h"
#include "lcd1602_i2c.h"




/*
 * Function: I2C0_Init
 * Purpose : Initialize I2C0 on PB2 (SCL) and PB3 (SDA)
 * Speed   : Standard Mode (100 kHz)
 */
void I2C0_Init(void)
{
    //
    // 1. Enable the I2C0 peripheral and GPIOB port
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_I2C0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);

    // Wait until ready
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_I2C0));
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOB));

    //
    // 2. Configure GPIO pins for I2C0
    // PB2 -> I2C0SCL
    // PB3 -> I2C0SDA
    //
    GPIOPinConfigure(GPIO_PB2_I2C0SCL);
    GPIOPinConfigure(GPIO_PB3_I2C0SDA);

    GPIOPinTypeI2CSCL(GPIO_PORTB_BASE, GPIO_PIN_2);  // SCL pin setup
    GPIOPinTypeI2C(GPIO_PORTB_BASE, GPIO_PIN_3);     // SDA pin setup

    //
    // 3. Initialize I2C Master
    // false = Standard Mode (100 kHz)
    // true  = Fast Mode (400 kHz)
    //
    I2CMasterInitExpClk(I2C0_BASE, SysCtlClockGet(), false);

    //
    // 4. Clear any previous I2C errors
    //
    I2CMasterEnable(I2C0_BASE);
}


uint8_t smiley[8] = {
    0b00000,
    0b01010,
    0b01010,
    0b00000,
    0b10001,
    0b01110,
    0b00000,
    0b00000
};

uint8_t icon1[8] = {0x00,0x0A,0x0A,0x00,0x11,0x0E,0x00,0x00}; // Smiley
uint8_t icon2[8] = {0x04,0x0E,0x15,0x04,0x04,0x04,0x04,0x00}; // Arrow Up
uint8_t icon3[8] = {0x04,0x04,0x04,0x04,0x15,0x0E,0x04,0x00}; // Arrow Down
uint8_t icon4[8] = {0x00,0x04,0x0E,0x1F,0x0E,0x04,0x00,0x00}; // Heart

int main(void)
{
    systemClockConfig();
    I2C0_Init();
    IntMasterEnable();

    LCD_Init();

    // // Print String
    // LCD_PrintString("Hello World!");
    // delay_ms(2000);
    // LCD_Clear();

    // // Print integer on Row 0, Column 0
    // LCD_SetCursor(0, 0);
    // LCD_PrintInt(1234);

    // // Print float on Row 1, Column 0
    // LCD_SetCursor(1, 0);
    // LCD_PrintFloat(3.1416, 3);

    
    // // Load custom character at location 0
    // LCD_CreateChar(0, smiley);

    // LCD_SetCursor(0, 0);
    // LCD_PrintString("Have a nice day");

    // LCD_SetCursor(1, 7);
    // LCD_SendData(0);   // Display the custom character


    // Load multiple custom characters
    LCD_CreateChar(0, icon1);
    LCD_CreateChar(1, icon2);
    LCD_CreateChar(2, icon3);
    LCD_CreateChar(3, icon4);

    LCD_SetCursor(0,0);
    LCD_PrintString("Custom Icons:");

    LCD_SetCursor(1,3);
    LCD_SendData(0);
    LCD_SendData(1);
    LCD_SendData(2);
    LCD_SendData(3);

    

    while(1)
    {
        // LCD_PrintString("Hello World from TM4C123G..");
        // delay_ms(500);
        // int i=0;
        // for(i=0; i < 40; i++) // scroll for the entire string length
        // {
        //     LCD_ScrollLeft();
        //     delay_ms(500);
        // }
        // LCD_Clear();
    }
}
