#ifndef LCD1602_I2C_H_
#define LCD1602_I2C_H_

#include <stdint.h>
#include <stdbool.h>

// Change this based on your module’s address (0x27 or 0x3F are common)
#define LCD_I2C_ADDR        0x27      

// Control bits
#define LCD_BACKLIGHT       0x08
#define LCD_NOBACKLIGHT     0x00
#define LCD_ENABLE_BIT      0x04

// LCD Commands
#define LCD_CLEAR           0x01
#define LCD_RETURN_HOME     0x02
#define LCD_ENTRY_MODE      0x06
#define LCD_DISPLAY_ON      0x0C
#define LCD_FUNCTION_SET    0x28
#define LCD_SET_CURSOR      0x80

void LCD_Init(void);
void LCD_SendCommand(uint8_t cmd);
void LCD_SendData(uint8_t data);

void LCD_Clear(void);
void LCD_BacklightOn(void);
void LCD_BacklightOff(void);

void LCD_PrintString(char *str);
void LCD_PrintInt(int num);
void LCD_PrintFloat(float num, int decimalPlaces);

void LCD_SetCursor(uint8_t row, uint8_t col);
void LCD_CreateChar(uint8_t location, uint8_t charmap[]);

void LCD_ScrollLeft(void);
void LCD_ScrollRight(void);

#endif
