#include <Adafruit_GFX.h>
#include <Adafruit_ST7735.h>
#include <SPI.h>
#include <SD.h>

#define TFT_CS   10
#define TFT_DC    9
#define TFT_RST   8
#define SD_CS     4

Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);

void setup() {
  Serial.begin(9600);
  tft.initR(INITR_BLACKTAB);
  tft.fillScreen(ST77XX_BLACK);

  
  // Initialize SD card
  if (!SD.begin(SD_CS)) {
    Serial.println("SD Card initialization failed!");
    return;
  }
  Serial.println("SD Card initialized.");
}

void loop() {
    // Display BMP image
  bmpDraw("image1.bmp", 0, 0);
  delay(2000);
  bmpDraw("image2.bmp", 0, 0);
  delay(2000); 
}

void bmpDraw(char *filename, uint8_t x, uint8_t y) {
  File bmpFile;
  int bmpWidth, bmpHeight;
  uint8_t bmpDepth;
  uint32_t bmpImageoffset;
  uint32_t rowSize;
  uint8_t sdbuffer[3*20]; // RGB buffer
  uint8_t buffidx = sizeof(sdbuffer);
  boolean goodBmp = false;
  boolean flip = true;
  int w, h, row, col;
  uint8_t r, g, b;

  if((x >= tft.width()) || (y >= tft.height())) return;
  bmpFile = SD.open(filename);
  if (!bmpFile) {
    Serial.println("File not found");
    return;
  }

  if (read16(bmpFile) == 0x4D42) { // BMP signature
    read32(bmpFile); read32(bmpFile);
    bmpImageoffset = read32(bmpFile);
    read32(bmpFile);
    bmpWidth  = read32(bmpFile);
    bmpHeight = read32(bmpFile);
    if(read16(bmpFile) == 1 && (bmpDepth = read16(bmpFile)) == 24 && read32(bmpFile) == 0) {
      goodBmp = true;
      rowSize = (bmpWidth * 3 + 3) & ~3;
      if(bmpHeight < 0) { bmpHeight = -bmpHeight; flip = false; }
      w = bmpWidth; h = bmpHeight;
      tft.setAddrWindow(x, y, x+w-1, y+h-1);
      for (row=0; row<h; row++) {
        bmpFile.seek(bmpImageoffset + (flip ? (bmpHeight - 1 - row) * rowSize : row * rowSize));
        buffidx = sizeof(sdbuffer);
        for (col=0; col<w; col++) {
          if (buffidx >= sizeof(sdbuffer)) {
            bmpFile.read(sdbuffer, sizeof(sdbuffer));
            buffidx = 0;
          }
          b = sdbuffer[buffidx++];
          g = sdbuffer[buffidx++];
          r = sdbuffer[buffidx++];
          tft.pushColor(tft.color565(r,g,b));
        }
      }
    }
  }
  bmpFile.close();
}

uint16_t read16(File &f) {
 uint16_t result;
 ((uint8_t *)&result)[0] = f.read();
 ((uint8_t *)&result)[1] = f.read(); 
 return result;
}
uint32_t read32(File &f) { 
  uint32_t result; 
  ((uint8_t *)&result)[0] = f.read(); 
  ((uint8_t *)&result)[1] = f.read(); 
  ((uint8_t *)&result)[2] = f.read(); 
  ((uint8_t *)&result)[3] = f.read(); 
  return result; 
}