#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SH110X.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1

Adafruit_SH1106G display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void setup() {
  display.begin(0x3C, true);
  display.clearDisplay();
}

void loop() {
  for (int x = 0; x < 128; x += 2) { // Move the box across the screen
    display.clearDisplay();
    display.fillRect(x, 25, 20, 20, SH110X_WHITE); // Draw a 20x20 box
    display.display();
    delay(20); // Adjust for animation speed
  }
}