#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SH110X.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1

Adafruit_SH1106G display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void setup() {
  display.begin(0x3C, true);
  display.clearDisplay();

  // Draw a line
  display.drawLine(0, 0, 127, 63, SH110X_WHITE);

  // Draw rectangle outline
  display.drawRect(10, 10, 50, 30, SH110X_WHITE);

  // Draw filled rectangle
  display.fillRect(70, 10, 40, 20, SH110X_WHITE);

  // Draw circle outline
  display.drawCircle(30, 50, 10, SH110X_WHITE);

  // Draw filled circle
  display.fillCircle(90, 50, 10, SH110X_WHITE);

  display.display();
}

void loop() {
}
