#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SH110X.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1

Adafruit_SH1106G display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// 16x16 WiFi icon bitmap (simple example)
static const unsigned char PROGMEM wifi_icon[] = {
  0b00000000, 0b00000000,
  0b00000111, 0b11100000,
  0b00011111, 0b11111000,
  0b00111100, 0b00111100,
  0b01110000, 0b00001110,
  0b01100011, 0b11000110,
  0b00001111, 0b11110000,
  0b00011100, 0b00111000,
  0b00110000, 0b00001100,
  0b00000000, 0b00000000,
  0b00000011, 0b11000000,
  0b00000111, 0b11100000,
  0b00000110, 0b01100000,
  0b00000000, 0b00000000,
  0b00000001, 0b10000000,
  0b00000000, 0b00000000
};

void setup() {
  display.begin(0x3C, true);
  display.clearDisplay();

  // Draw WiFi icon at (10, 20)
  display.drawBitmap(10, 20, wifi_icon, 16, 16, SH110X_WHITE);

  // Draw text next to icon
  display.setTextSize(1);
  display.setTextColor(SH110X_WHITE);
  display.setCursor(30, 26);
  display.print("Connected");

  // Update display
  display.display();
}

void loop() {
}
