#include <stdio.h>
#include <stdbool.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "driver/gpio.h"

#define LED_GPIO     2    // On-board LED for most ESP32 DevKit boards
#define BUTTON_GPIO  0    // BOOT button on DevKit, pulled up by default

TaskHandle_t ledTaskHandle = NULL;

void ledTask(void *pvParameters)
{
    int blinkCount = 0;

    while (1)
    {
        // Toggle LED
        gpio_set_level(LED_GPIO, 1);
        printf("LED ON\n");
        vTaskDelay(pdMS_TO_TICKS(300));

        gpio_set_level(LED_GPIO, 0);
        printf("LED OFF\n");
        vTaskDelay(pdMS_TO_TICKS(300));

        blinkCount++;

        // After 5 blinks, suspend the task
        if (blinkCount == 5)
        {
            printf("Suspending LED Task...\n");
            vTaskSuspend(NULL);  // Suspend itself

            // Reset counter after resume
            blinkCount = 0;
        }
    }
}

void controllerTask(void *pvParameters)
{
    while (1)
    {
        // Button is active LOW
        if (gpio_get_level(BUTTON_GPIO) == 0)
        {
            printf("Button Pressed: Resuming LED Task\n");
            vTaskResume(ledTaskHandle);

            // Debounce delay
            vTaskDelay(pdMS_TO_TICKS(500));
        }

        vTaskDelay(pdMS_TO_TICKS(50));
    }
}

void app_main(void)
{
    // Configure LED pin
    gpio_reset_pin(LED_GPIO);
    gpio_set_direction(LED_GPIO, GPIO_MODE_OUTPUT);

    // Configure button pin
    gpio_reset_pin(BUTTON_GPIO);
    gpio_set_direction(BUTTON_GPIO, GPIO_MODE_INPUT);
    gpio_pullup_en(BUTTON_GPIO);      // Button is active-low
    gpio_pulldown_dis(BUTTON_GPIO);

    // Create tasks
    xTaskCreate(ledTask, "LED_Task", 2048, NULL, 5, &ledTaskHandle);
    xTaskCreate(controllerTask, "Controller_Task", 2048, NULL, 4, NULL);
}