#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"

TaskHandle_t workerTaskHandle = NULL;

void workerTask(void *pvParameters)
{
    for (int i = 1; i <= 5; i++)
    {
        printf("Worker Task: Step %d/5\n", i);
        vTaskDelay(pdMS_TO_TICKS(500));
    }

    printf("Worker Task: Work complete. Deleting myself...\n");
    vTaskDelete(NULL);  // Self-delete
}

void monitorTask(void *pvParameters)
{
    while (1)
    {
        if (workerTaskHandle != NULL)
        {
            eTaskState state = eTaskGetState(workerTaskHandle);

            if (state == eDeleted)
            {
                printf("Monitor Task: Worker Task has been deleted.\n");
                workerTaskHandle = NULL; // Avoid using a dead handle
            }
        }

        vTaskDelay(pdMS_TO_TICKS(300));
    }
}

void app_main(void)
{
    xTaskCreate(workerTask, "WorkerTask", 2048, NULL, 5, &workerTaskHandle);
    xTaskCreate(monitorTask, "MonitorTask", 2048, NULL, 4, NULL);
}
