#include <U8g2lib.h>
#include <SPI.h>

// Constructor used in your previous tutorial
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

// ---- Corrected 16x16 WiFi Bitmap (bit-swapped) ----
const unsigned char wifi_icon [] PROGMEM = {
	// 'undefined, 16x16px
	0x00, 0x00, 0xf0, 0x01, 0xf8, 0x03, 0x1c, 0x07, 0x0e, 0x0e, 0x06, 0x0c, 0xe3, 0x18, 0xf1, 0x11, 
	0x38, 0x03, 0x18, 0x03, 0x0c, 0x06, 0x0c, 0x06, 0x00, 0x00, 0x30, 0x00, 0x78, 0x00, 0x78, 0x00
};


void setup() {
  u8g2.begin();
}

void loop() {

  u8g2.firstPage();
  do {

    // ----- Draw WiFi Icon (Top-Right Corner) -----
    int iconX = 128 - 16;   // screen width - icon width
    int iconY = 0;
    u8g2.drawXBMP(iconX, iconY, 16, 16, wifi_icon);

    // ----- Draw Text "Connected" -----
    u8g2.setFont(u8g2_font_4x6_tf);
    u8g2.drawStr(iconX - 20, 26, "Connected");

  } while (u8g2.nextPage());   // required for ST7920

  delay(1000);
}
