#include <U8g2lib.h>
#include <SPI.h>

// Constructor used in your previous tutorial
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

int level = 0;  // Battery fill level (0–20)

void setup() {
  u8g2.begin();
}

void loop() {
  level += 2;
  if (level>=20) level=0;

  u8g2.clearBuffer();

  // Draw battery body
  u8g2.drawFrame(5, 5, 20, 10);    // Main body frame
  u8g2.drawBox(26, 7, 3, 6);       // Battery tip

  // Draw fill level
  u8g2.drawBox(6, 6, level, 8);    // Fill bar

  // Label
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(5, 25, "Battery");

  u8g2.sendBuffer();
  delay(1000);
}