#include <Arduino.h>
#include <U8g2lib.h>
#include <SPI.h>

// Constructor used in your previous tutorial
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

void setup() {
  u8g2.begin();
}

void loop() {

  // Animate signal strength from 0 to 4 bars
  for (int strength = 0; strength <= 4; strength++) {
    u8g2.clearBuffer();

    // Title text
    u8g2.setFont(u8g2_font_6x10_tf);
    u8g2.drawStr(10, 15, "Signal Strength");

    // Draw bars based on strength
    if (strength >= 1) u8g2.drawBox(10, 55, 4, 5);     // Bar 1
    if (strength >= 2) u8g2.drawBox(16, 52, 4, 8);     // Bar 2
    if (strength >= 3) u8g2.drawBox(22, 49, 4, 11);    // Bar 3
    if (strength >= 4) u8g2.drawBox(28, 46, 4, 14);    // Bar 4

    // Optional label
    u8g2.drawStr(40, 55, String(strength).c_str());

    u8g2.sendBuffer();
    delay(400);    // Slow animation so changes are visible
  }

  delay(800);      // Pause before restarting the cycle
}
