#include <Arduino.h>
#include <U8g2lib.h>
#include <SPI.h>

// Constructor used in your previous tutorial
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

void setup() {
  u8g2.begin();
}

void loop() {

  // Animate progress bar from 0 to 96 pixels
  for (int p = 0; p <= 96; p++) {
    u8g2.clearBuffer();

    // Outer border of progress bar
    u8g2.drawFrame(10, 30, 100, 12);

    // Growing bar
    u8g2.drawBox(12, 32, p, 8);

    // Text label
    u8g2.setFont(u8g2_font_6x10_tf);
    u8g2.drawStr(10, 20, "Loading...");

    u8g2.sendBuffer();
    delay(20);
  }

  delay(500);  // Pause before restarting the animation
}