#include <U8g2lib.h>
#include <Arduino.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(
  U8G2_R2,
  /* clock=*/ 13,
  /* data=*/ 11,
  /* cs=*/ 10,
  /* reset=*/ 8
);

// Button pins
const int UP_BTN = 2;
const int DOWN_BTN = 3;
const int SELECT_BTN = 4;

// Menu Settings
int menuIndex = 0;
const int MENU_ITEMS = 3;
String menuList[MENU_ITEMS] = {"Home", "Settings", "Info"};

bool inSubMenu = false;

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_6x10_tr);

  pinMode(UP_BTN, INPUT_PULLUP);
  pinMode(DOWN_BTN, INPUT_PULLUP);
  pinMode(SELECT_BTN, INPUT_PULLUP);
}

void drawMenu() {
  for (int i = 0; i < MENU_ITEMS; i++) {
    int y = 16 + i * 14;

    if (i == menuIndex) {
      u8g2.drawBox(0, y - 10, 128, 12);
      u8g2.setDrawColor(0);
      u8g2.setCursor(4, y);
      u8g2.print(menuList[i]);
      u8g2.setDrawColor(1);
    } else {
      u8g2.setCursor(4, y);
      u8g2.print(menuList[i]);
    }
  }
}

void drawSubPage(int page) {
  u8g2.setCursor(10, 32);
  if (page == 0) u8g2.print("Home Screen");
  if (page == 1) u8g2.print("Settings Page");
  if (page == 2) u8g2.print("Info Page");

  u8g2.setCursor(10, 50);
  u8g2.print("Press SELECT to go back");
}

void loop() {
  if (!inSubMenu) {

    // Handling button presses
    if (!digitalRead(UP_BTN)) {
      menuIndex--;
      if (menuIndex < 0) menuIndex = MENU_ITEMS - 1;
      delay(150);
    }
    if (!digitalRead(DOWN_BTN)) {
      menuIndex++;
      if (menuIndex >= MENU_ITEMS) menuIndex = 0;
      delay(150);
    }
    if (!digitalRead(SELECT_BTN)) {
      inSubMenu = true;
      delay(200);
    }

    // Draw menu
    u8g2.firstPage();
    do {
      drawMenu();
    } while (u8g2.nextPage());
  }

  else {  
    // Draw selected page
    u8g2.firstPage();
    do {
      drawSubPage(menuIndex);
    } while (u8g2.nextPage());

    // Exit submenu
    if (!digitalRead(SELECT_BTN)) {
      inSubMenu = false;
      delay(200);
    }
  }
}
