#include <U8g2lib.h>
#include <Arduino.h>

// ST7920 SPI Constructor (same as in previous tutorials)
U8G2_ST7920_128X64_F_SW_SPI u8g2(
  U8G2_R0, 
  /* clock=*/ 13, 
  /* data=*/ 11, 
  /* cs=*/ 10, 
  /* reset=*/ 8
);

// Graph settings
const int SENSOR_PIN = A0;
int graphData[128];     // Buffer for 128 graph points
int indexPos = 0;

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_6x10_tr);

  // Initialize graph buffer
  for (int i = 0; i < 128; i++) {
    graphData[i] = 32;
  }
}

void loop() {

  // Read analog sensor (0–1023)
  int raw = analogRead(SENSOR_PIN);

  // Map to ST7920 graph height (0–63)
  int y = map(raw, 0, 1023, 63, 0);

  // Add new value into buffer
  for (int i = 0; i < 127; i++) {
    graphData[i] = graphData[i + 1];
  }
  graphData[127] = y;

  // Draw Graph
  u8g2.firstPage();
  do {

    // Optional gridlines
    for (int i = 0; i < 128; i += 16) {
      u8g2.drawLine(i, 0, i, 63);
    }
    for (int j = 0; j < 64; j += 16) {
      u8g2.drawLine(0, j, 127, j);
    }

    // Plot graph
    for (int x = 0; x < 127; x++) {
      u8g2.drawLine(x, graphData[x], x + 1, graphData[x + 1]);
    }

    // Print current sensor value
    u8g2.setCursor(2, 10);
    u8g2.print("Value: ");
    u8g2.print(raw);

  } while (u8g2.nextPage());

  delay(40);  // controls graph scrolling speed
}
