#include <U8g2lib.h>
#include <Arduino.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(
  U8G2_R2, 
  /* clock=*/13, 
  /* data=*/11, 
  /* cs=*/10, 
  /* reset=*/8
);

const unsigned char icon_battery[] U8X8_PROGMEM = {
0x00, 0xc0, 0xfe, 0xbf, 0x0a, 0xbd, 0x0a, 0x3d, 0x0a, 0x3d, 0x0a, 0xbd, 0xfe, 0xbf, 0x00, 0xc0
};

const unsigned char icon_wifi[] U8X8_PROGMEM = {
	0xff, 0xff, 0x7f, 0xfe, 0x8f, 0xf1, 0xf7, 0xef, 0x1b, 0xd8, 0xed, 0xb7, 0xf6, 0x6f, 0x1b, 0xd8, 
	0xeb, 0xd3, 0xf7, 0xef, 0x1f, 0xf8, 0xdf, 0xfb
};
const unsigned char icon_temp[] U8X8_PROGMEM = {
  0x18,
  0x18,
  0x18,
  0x18,
  0x7E,
  0x7E,
  0x3C,
  0x18
};

// Graph Data
int graphData[50];

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_6x10_tr);

  for (int i = 0; i < 50; i++) graphData[i] = 32;
}

void updateGraph(int value) {
  for (int i = 0; i < 49; i++) {
    graphData[i] = graphData[i + 1];
  }
  graphData[49] = value;
}

void drawDashboard(int temp, int hum, int wifi, int batt) {

  u8g2.firstPage();
  do {

    // Header Bar
    u8g2.drawBox(0, 0, 128, 12);
    u8g2.setDrawColor(0);   // Invert text on header
    u8g2.setCursor(4, 10);
    u8g2.print("DASHBOARD");
    u8g2.setDrawColor(1);

    // Icons
    u8g2.drawXBMP(110, 2, 16, 8, icon_battery);
    u8g2.drawXBMP(90, 0, 16, 12, icon_wifi);

    // Temperature
    u8g2.drawXBMP(4, 20, 8, 8, icon_temp);
    u8g2.setCursor(16, 27);
    u8g2.print("Temp: ");
    u8g2.print(temp);
    u8g2.print(" C");

    // Humidity
    u8g2.setCursor(16, 40);
    u8g2.print("Hum : ");
    u8g2.print(hum);
    u8g2.print(" %");

    // Graph Label
    u8g2.setCursor(4, 53);
    u8g2.print("History:");

    // Draw Live Graph
    for (int x = 0; x < 49; x++) {
      u8g2.drawLine(65 + x, graphData[x], 65 + x + 1, graphData[x + 1]);
    }

  } while (u8g2.nextPage());
}

void loop() {

  int temp = random(20, 35);
  int hum  = random(40, 75);

  // Map temperature to graph height
  int g = map(temp, 20, 35, 60, 45);
  updateGraph(g);

  drawDashboard(temp, hum, 1, 1);

  delay(300);
}
