#include <U8g2lib.h>
#include <math.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

float phase = 0;

void setup() {
  u8g2.begin();
}

void loop() {

  u8g2.firstPage();
  do {
    for (int x = 0; x < 128; x++) {
      float yVal = 32 + 20 * sin((x * 0.15) + phase);
      u8g2.drawPixel(x, (int)yVal);
    }
  } while (u8g2.nextPage());

  phase += 0.2;   // shift waveform horizontally
  if (phase > 1000) phase = 0;

  delay(40);
}