#include <Arduino.h>
#include <U8g2lib.h>
#include <SPI.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R2, 13, 11, 10, 8);

int yPos = 64;                     // Start from bottom edge
const char* vText = "Scrolling Vertically";
const unsigned long frameDelay = 40;

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_6x12_tf);
}

void loop() {
  u8g2.firstPage();
  do {
    u8g2.drawStr(10, yPos, vText);
  } while (u8g2.nextPage());

  yPos--;

  // Reset once the text scrolls out of view
  if (yPos < -10) {
    yPos = 64;
  }

  delay(frameDelay);
}


/* Change Direction
line 7 -> int yPos = -10;     // instead of 64
line 22 -> yPos++;             // instead of yPos--
line 25 -> if (yPos > 64) {    // instead of yPos < -10
    yPos = -10;
}
*/