#include <U8g2lib.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

void drawPageA() {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(10, 25, "This is PAGE A");
}

void drawPageB() {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(10, 25, "This is PAGE B");
}

void setup() {
  u8g2.begin();
}

void softSwitch(void (*pageA)(), void (*pageB)()) {
  // Fade bottom up
  for (int h = 0; h <= 64; h += 6) {
    u8g2.firstPage();
    do {
      pageA();
      u8g2.setDrawColor(0);
      u8g2.drawBox(0, 64 - h, 128, h);
      u8g2.setDrawColor(1);
    } while (u8g2.nextPage());
    delay(40);
  }

  // Fade-in next page
  for (int h = 64; h >= 0; h -= 6) {
    u8g2.firstPage();
    do {
      pageB();
      u8g2.setDrawColor(0);
      u8g2.drawBox(0, 0, 128, h);
      u8g2.setDrawColor(1);
    } while (u8g2.nextPage());
    delay(40);
  }
}

void loop() {
  softSwitch(drawPageA, drawPageB);
  delay(1000);
  softSwitch(drawPageB, drawPageA);
  delay(1000);
}