#include <U8g2lib.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

int offset = 0;
bool nextPage = false;

void drawPage1(int x) {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(x + 10, 20, "PAGE 1");
  u8g2.drawStr(x + 10, 40, "This is the first screen");
}

void drawPage2(int x) {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(x + 10, 20, "PAGE 2");
  u8g2.drawStr(x + 10, 40, "Welcome to the next page");
}

void setup() {
  u8g2.begin();
}

void loop() {

  if (!nextPage) {
    // ---- Slide Left (Page 1 → Page 2) ----
    for (offset = 0; offset >= -128; offset -= 8) {
      u8g2.firstPage();
      do {
        drawPage1(offset);
        drawPage2(offset + 128);
      } while (u8g2.nextPage());
      delay(40);
    }
    nextPage = true;
    delay(1000);
  } 
  else {
    // ---- Slide Right (Page 2 → Page 1) ----
    for (offset = -128; offset <= 0; offset += 8) {
      u8g2.firstPage();
      do {
        drawPage1(offset);
        drawPage2(offset + 128);
      } while (u8g2.nextPage());
      delay(40);
    }
    nextPage = false;
    delay(1000);
  }
}