#include <Arduino.h>
#include <U8g2lib.h>
#include <SPI.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R2, 13, 11, 10, 8);

const char* banner = " Welcome to Controllerstech ";
int textWidth;
int xPos = 0;
const int displayWidth = 128;

unsigned long lastMillis = 0;
const unsigned long frameDelay = 250;

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_7x14B_tf);   // Bold font for banner
  textWidth = u8g2.getStrWidth(banner);
}

void loop() {
  if (millis() - lastMillis < frameDelay) return;
  lastMillis = millis();

  u8g2.firstPage();
  do {
    // Draw banner background
    u8g2.drawBox(0, 0, 128, 16);

    // Draw two copies of the text for seamless scrolling
    u8g2.setDrawColor(0); // White text on black
    u8g2.drawStr(xPos, 14, banner);
    u8g2.drawStr(xPos + textWidth, 14, banner);
    u8g2.setDrawColor(1);
  } while (u8g2.nextPage());

  xPos--;

  // Seamless reset
  if (xPos <= -textWidth) {
    xPos += textWidth;
  }
}

/* Change Direction
line 37 -> xPos++;      // instead of xPos--
line 40 -> if (xPos >= textWidth) {   // instead of xPos <= -textWidth
    xPos -= textWidth;
}
*/