#include <U8g2lib.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

// Simple 32x16 logo bitmap (replace with your actual logo)
const unsigned char logoBitMap[] PROGMEM = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0x01, 
	0x00, 0xf8, 0xff, 0x07, 0x00, 0xee, 0xff, 0x0f, 0x00, 0xbb, 0xfd, 0x3f, 0x80, 0xed, 0x77, 0x38, 
	0xc0, 0xb6, 0x1d, 0x60, 0x60, 0xdb, 0x06, 0xc0, 0xb0, 0x6d, 0x03, 0x80, 0xdc, 0xb6, 0x01, 0x00, 
	0x74, 0xdf, 0x60, 0x40, 0xbc, 0x6f, 0x50, 0xa4, 0xd8, 0x3e, 0x70, 0xea, 0x68, 0x18, 0x10, 0x2e, 
	0x7e, 0x18, 0x08, 0x12, 0x77, 0x0e, 0x34, 0x09, 0x35, 0x0f, 0x92, 0x1c, 0x02, 0x06, 0xfb, 0x2e, 
	0x00, 0x80, 0x6d, 0x3b, 0x00, 0xc0, 0xb6, 0x0d, 0x02, 0x60, 0xdb, 0x06, 0x06, 0x90, 0x6d, 0x03, 
	0x1c, 0x6c, 0xb2, 0x01, 0xf8, 0xbb, 0xc9, 0x00, 0xf0, 0x7f, 0x36, 0x00, 0xe0, 0xff, 0x1d, 0x00, 
	0x80, 0xff, 0x07, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

int xPos = -40;   // start outside screen

void setup() {
  u8g2.begin();
}

void loop() {
  xPos += 4;

  if (xPos > 48) xPos = -40;  // reset and repeat

  u8g2.firstPage();
  do {
    u8g2.drawXBMP(xPos, 24, 32, 32, logoBitMap);
  } while (u8g2.nextPage());

  delay(60);
}