#include <Arduino.h>
#include <U8g2lib.h>
#include <SPI.h>

// ST7920 128x64 using Software SPI
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R2, /* clock=*/ 13, /* data=*/ 11, /* CS=*/ 10, /* reset=*/ 8);

const char msg[] = "Controllerstech Tutorials";
int displayWidth = 128;     // ST7920 width in pixels
int textWidth;              // Pixel width of the message
int xPos;                   // Current X position of the text

unsigned long lastMillis = 0;
const unsigned long frameDelay = 40;

void setup() {
  u8g2.begin();
  u8g2.setFont(u8g2_font_9x15_tf);

  // Measure text width after setting the font
  textWidth = u8g2.getStrWidth(msg);

  // Start the text just outside the right edge
  xPos = displayWidth;
}

void loop() {
  // Maintain stable frame timing
  if (millis() - lastMillis < frameDelay) return;
  lastMillis = millis();

  u8g2.firstPage();
  do {
    u8g2.drawStr(xPos, 32, msg);   // Draw text horizontally centered
  } while (u8g2.nextPage());

  // Move text left
  xPos--;

  // When text moves fully off the left side, reset it to the right side
  if (xPos < -textWidth) {
    xPos = displayWidth;
  }
}


/* Scroll left-to-right 
line 24 -> xPos = -textWidth;
line 38 -> xPos++;
line 41 -> if (xPos > displayWidth) {
    xPos = -textWidth;
}
*/
