#include <U8g2lib.h>
#include <Wire.h>

// Using 128x64 ST7920 SPI
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

const unsigned char frame1[] PROGMEM = {
  0x00,0x18,0x3C,0x7E,0x3C,0x18,0x00
};

const unsigned char frame2[] PROGMEM = {
  0x00,0x0C,0x1E,0x3F,0x1E,0x0C,0x00
};

void setup() {
  u8g2.begin();
}

void loop() {
  u8g2.firstPage();
  do {
    u8g2.drawXBMP(60, 24, 7, 7, frame1);
  } while (u8g2.nextPage());
  delay(150);

  u8g2.firstPage();
  do {
    u8g2.drawXBMP(60, 24, 7, 7, frame2);
  } while (u8g2.nextPage());
  delay(150);
}