#include <U8g2lib.h>

U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, 13, 11, 10, 8);

void drawPage() {
  u8g2.setFont(u8g2_font_6x10_tf);
  u8g2.drawStr(20, 30, "Fading Page...");
}

void setup() {
  u8g2.begin();
}

void loop() {

  // Draw the full page
  u8g2.firstPage();
  do {
    drawPage();
  } while (u8g2.nextPage());

  delay(1000);

  // ---- Gradual Fade ----
  for (int i = 0; i < 64; i += 4) {
    u8g2.firstPage();
    do {
      drawPage();               // redraw page
      u8g2.setDrawColor(0);     // set color to erase
      u8g2.drawBox(0, i, 128, 4); // clear strip
      u8g2.setDrawColor(1);
    } while (u8g2.nextPage());
    delay(40);
  }

  delay(800);
}